/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._weakref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.modules._weakref.AbstractReference;
import org.python.util.Generic;

public class GlobalRef
extends WeakReference {
    private int hashCode;
    private int pythonHashCode;
    private boolean havePythonHashCode;
    private List references = new ArrayList();
    private static ReferenceQueue referenceQueue = new ReferenceQueue();
    private static RefReaperThread reaperThread;
    private static ConcurrentMap<GlobalRef, GlobalRef> objects;

    public GlobalRef(PyObject pyObject) {
        super(pyObject, referenceQueue);
        this.hashCode = System.identityHashCode(pyObject);
    }

    public synchronized void add(AbstractReference abstractReference) {
        WeakReference<AbstractReference> weakReference = new WeakReference<AbstractReference>(abstractReference);
        this.references.add(weakReference);
    }

    private final AbstractReference getReferenceAt(int n) {
        WeakReference weakReference = (WeakReference)this.references.get(n);
        return (AbstractReference)weakReference.get();
    }

    synchronized AbstractReference find(Class clazz) {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference abstractReference = this.getReferenceAt(i);
            if (abstractReference == null) {
                this.references.remove(i);
                continue;
            }
            if (abstractReference.callback != null || abstractReference.getClass() != clazz) continue;
            return abstractReference;
        }
        return null;
    }

    synchronized void call() {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference abstractReference = this.getReferenceAt(i);
            if (abstractReference == null) {
                this.references.remove(i);
                continue;
            }
            abstractReference.call();
        }
    }

    public synchronized int count() {
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference abstractReference = this.getReferenceAt(i);
            if (abstractReference != null) continue;
            this.references.remove(i);
        }
        return this.references.size();
    }

    public synchronized PyList refs() {
        ArrayList<AbstractReference> arrayList = new ArrayList<AbstractReference>();
        for (int i = this.references.size() - 1; i >= 0; --i) {
            AbstractReference abstractReference = this.getReferenceAt(i);
            if (abstractReference == null) {
                this.references.remove(i);
                continue;
            }
            arrayList.add(abstractReference);
        }
        return new PyList(arrayList);
    }

    public static GlobalRef newInstance(PyObject pyObject) {
        GlobalRef globalRef = (GlobalRef)objects.get(new GlobalRef(pyObject));
        if (globalRef == null) {
            globalRef = new GlobalRef(pyObject);
            objects.put(globalRef, globalRef);
        }
        return globalRef;
    }

    public static int getCount(PyObject pyObject) {
        GlobalRef globalRef = (GlobalRef)objects.get(new GlobalRef(pyObject));
        return globalRef == null ? 0 : globalRef.count();
    }

    public static PyList getRefs(PyObject pyObject) {
        GlobalRef globalRef = (GlobalRef)objects.get(new GlobalRef(pyObject));
        return globalRef == null ? new PyList() : globalRef.refs();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GlobalRef)) {
            return false;
        }
        Object t = this.get();
        Object t2 = ((GlobalRef)object).get();
        if (t == null || t2 == null) {
            return false;
        }
        return t == t2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int pythonHashCode() {
        if (this.havePythonHashCode) {
            return this.pythonHashCode;
        }
        Object t = this.get();
        if (t == null) {
            throw Py.TypeError("weak object has gone away");
        }
        this.pythonHashCode = t.hashCode();
        this.havePythonHashCode = true;
        return this.pythonHashCode;
    }

    private static void initReaperThread() {
        reaperThread = new RefReaperThread();
        reaperThread.setDaemon(true);
        reaperThread.start();
    }

    static {
        objects = Generic.concurrentMap();
        GlobalRef.initReaperThread();
    }

    private static class RefReaperThread
    extends Thread {
        RefReaperThread() {
            super("weakref reaper");
        }

        public void collect() throws InterruptedException {
            GlobalRef globalRef = (GlobalRef)referenceQueue.remove();
            globalRef.call();
            objects.remove(globalRef);
            globalRef = null;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.collect();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

